//-------------------------------------------------------------------------------
//-------------------------------------------------------------------------------
//
//	File:
//		NxPNG Save.cpp
//
//	Description:
//		Export paletted PNGs from Photoshop via a batch process of operations
//
//-------------------------------------------------------------------------------
//-------------------------------------------------------------------------------
//	Includes
//-------------------------------------------------------------------------------
#define OLDP2C 1

#include "NxPNG Save.h"
#include "ADMBasic.h"
#include "ADMItem.h"
#include "SPFiles.h"
#include <process.h>
//-------------------------------------------------------------------------------
//	Classes
//-------------------------------------------------------------------------------
// This is based on the AutomationPlugin class found in AutomationPlugin.h. 
// The PluginMain routine is now in AutomationMain.cpp and this class gets 
// created and deleted depending on the messages.
class AutoNxPNGPlugin : public AutomationPlugin {
private:

	// a message from Photoshop menu or action
	virtual SPErr DoIt(PSActionsPlugInMessage *message);
	virtual ASErr UnloadPlugin(SPInterfaceMessage *message);

	// don't create these classes, there should be only one
	AutoNxPNGPlugin(); // don't write this one
	AutoNxPNGPlugin(AutoNxPNGPlugin &rhs); // don't write this one

public:
	// These are protected, only the Instance routine can call them.
	AutoNxPNGPlugin(SPPluginRef pluginRef);
	virtual ~AutoNxPNGPlugin();
};


//-------------------------------------------------------------------------------
//	Globals
//-------------------------------------------------------------------------------
// the basic suite, needed for the new and delete operators
SPBasicSuite *sSPBasic = NULL;

// global suite pointers needed by the PIUActionUtils routines
PSActionDescriptorProcs *sPSActionDescriptor = NULL;
PSActionControlProcs *sPSActionControl = NULL;
PSActionReferenceProcs *sPSActionReference = NULL;
PSActionListProcs *sPSActionList = NULL;
ADMBasicSuite			*sADMBasic = NULL;
ADMItemSuite			*sADMItem = NULL;
PSHandleSuite1 *sPSHandle = NULL;

// global suite pointers name and version information
// make sure this is global and the AutomationPlugin base class
// will acquire and release these as needed
ImportSuite gImportSuites[] =
{
	kPSActionDescriptorSuite, kPSActionDescriptorSuiteVersion, (void **)&sPSActionDescriptor,
	kPSActionListSuite, kPSActionListSuiteVersion, (void **)&sPSActionList,
	kPSActionReferenceSuite, kPSActionReferenceSuiteVersion, (void **)&sPSActionReference,
	kPSActionControlSuite, kPSActionControlSuitePrevVersion, (void **)&sPSActionControl,
	kADMBasicSuite, kADMBasicSuiteVersion, (void **)&sADMBasic,
	kADMItemSuite, kADMItemSuiteVersion, (void **)&sADMItem,
	kPSHandleSuite, kPSHandleSuiteVersion1, (void **)&sPSHandle,

	NULL, 0, NULL // this has to be last
};

//-------------------------------------------------------------------------------
//
//	ParseFilenameToDisplay.
//
//	Takes a SPPlatformFileSpec and returns the shortened filename.
//
//-------------------------------------------------------------------------------
static SPErr ParseFilenameToDisplay
	(
	/* IN */	const SPPlatformFileSpecification fileSpec,
	/* OUT */	char displayString[_MAX_PATH]
	)
	{
	SPErr error = kSPNoError;
	
	#ifdef __PIMac__
	
		strncpy(displayString, (const char*)&fileSpec.name[1], fileSpec.name[0]);
		displayString[fileSpec.name[0]] = 0;
	
	#elif defined(__PIWin__)
	
		_splitpath
			(
			fileSpec.path,
			NULL,			// drive,
			NULL,			// directory,
			displayString,	// filename
			NULL			// extension
			);
	#endif
	
	return error;
	
	} // ParseFilenameToDisplay

void EnsureFileAccess( char* path )
{
	int process_result;
	DWORD attribs;

	attribs = GetFileAttributes( path );
	if( attribs != -1 )
	{				
		if( attribs & FILE_ATTRIBUTE_READONLY )
		{
			char *args[4];

			args[0] = "p4";
			args[1] = "edit";
			args[2] = path;
			args[3] = NULL;
			process_result = spawnvp( _P_WAIT, args[0], args );
			if( process_result == -1 )
			{
				//error = -1;
				//goto returnError;
			}
		}
	}
}

SPErr PlayeventSave( char* file_path )
{
	PIActionDescriptor desc00000050 = NULL;
	PIActionDescriptor desc00000058 = NULL;
	Handle aliasValue = NULL;

	PIActionDescriptor result = NULL;
	DescriptorTypeID runtimeObjID;
	SPErr error = kSPNoError;
	ASBoolean success = false;
     

	error = sPSActionDescriptor->Make(&desc00000050);
	if (error) goto returnError;

	error = sPSActionDescriptor->Make(&desc00000058);
	if (error) goto returnError;

	error = sPSActionDescriptor->PutBoolean(desc00000058, 'barF', true);
	if (error) goto returnError;

	error = sPSActionControl->StringIDToTypeID("Neversoft NxPNG", &runtimeObjID);
	if (error) goto returnError;

	error = sPSActionDescriptor->PutObject(desc00000050, keyAs, runtimeObjID, desc00000058);
	if (error) goto returnError;

	SPPlatformFileSpecification startingDir;
	SPPlatformFileSpecification file_result;
	
	_splitpath( file_path, NULL, startingDir.path, NULL, NULL );
	success = sADMBasic->StandardPutFileDialog(	"Save As",
												&startingDir,
												file_path,
												&file_result);
		
	if (success)
	{
		DWORD attribs;

		EnsureFileAccess( file_result.path );
		
		attribs = GetFileAttributes( file_result.path );
		if( attribs != -1 )
		{				
			if( attribs & FILE_ATTRIBUTE_READONLY )
			{
				sADMBasic->ErrorAlert("Error: This file is either read-only or checked out by someone else and cannot be written to.");
				error = userCanceledErr;
				goto returnError;
			}
		}
		FullPathToAlias( file_result.path, aliasValue );
		error = sPSActionDescriptor->PutAlias(desc00000050, keyIn, aliasValue);
		if (error) goto returnError;	
	}
	else
	{
		error = userCanceledErr;
		goto returnError;
	}
	
	error = sPSActionControl->Play(&result, eventSave, desc00000050, plugInDialogSilent);
	if (error) goto returnError;

returnError:
     if (result != NULL) sPSActionDescriptor->Free(result);
     if (desc00000050 != NULL) sPSActionDescriptor->Free(desc00000050);
     if (desc00000058 != NULL) sPSActionDescriptor->Free(desc00000058);
     if (aliasValue != NULL) sPSHandle->Dispose(aliasValue);
     return error;
}


//-------------------------------------------------------------------------------
//
//	AutoNxPNGPlugin::AutoNxPNGPlugin
//
//	Derived class constructor. Make sure you initialize the base class.
//
//-------------------------------------------------------------------------------
AutoNxPNGPlugin::AutoNxPNGPlugin(SPPluginRef pluginRef) : AutomationPlugin(pluginRef)
{
}


//-------------------------------------------------------------------------------
//
//	AutoNxPNGPlugin::UnloadPlugin
//
//	Your about to get unloaded from memory. Delete anything dynamically created.
//
//-------------------------------------------------------------------------------
ASErr AutoNxPNGPlugin::UnloadPlugin(SPInterfaceMessage *message)
{
	return (AutomationPlugin::UnloadPlugin(message));
}


//-------------------------------------------------------------------------------
//
//	AutoNxPNGPlugin::~AutoNxPNGPlugin
//
//	Derived class destructor. Nothing to do for this class.
//  You should probably do clean up and memory overhead removal
//  during the UnloadPlugin call
//
//-------------------------------------------------------------------------------
AutoNxPNGPlugin::~AutoNxPNGPlugin()
{
}



//-------------------------------------------------------------------------------
//
//	AllocatePlugin
//	
//	The real constructor hear. You have to have one of these so the 
//	AutomationMain.cpp PluginMain routine can create your class.
//
//-------------------------------------------------------------------------------
AutomationPlugin *AllocatePlugin(SPPluginRef pluginRef)
{
	return new AutoNxPNGPlugin(pluginRef);
}



//-------------------------------------------------------------------------------
//
//	AutoNxPNGPlugin::DoIt
//
//	Entry point for our plugin's work.
//
//-------------------------------------------------------------------------------
SPErr AutoNxPNGPlugin::DoIt(PSActionsPlugInMessage * message)
{
	SPErr error = kSPNoError;
	SPMessageData *basicMessage = NULL;
	bool show_dialogs = false ;
	bool same_file = true;

	if( message->actionParameters->playInfo == plugInDialogDisplay )
	{
		show_dialogs = true ;
	}
	
	// all messages contain a SPMessageData*
	basicMessage = (SPMessageData *) &message->d;
	sSPBasic = basicMessage->basic;

	// Photoshop is calling
	//if (sSPBasic->IsEqual((char*)caller, kPSPhotoshopCaller))
	{
		// the one and only message 
		//if (sSPBasic->IsEqual((char*)selector, kPSDoIt))
		{
			int32 currentDocumentID = 0;
			int32 numDocuments = 0;

			// we are ignoring errors so this will not give an invalid error
			// message when there are no documents open
			PIUGetInfo(classApplication, keyNumberOfDocuments, &numDocuments, NULL);
			PIUGetInfo(classDocument, keyDocumentID, &currentDocumentID, NULL);

			if (numDocuments > 0)
			{
				char src_file_path[_MAX_PATH];
				Handle file_ref;

				error = PIUGetInfoByID(currentDocumentID, classDocument, keyFileReference, &file_ref, 0);
				if (error) goto returnError;
				
				AliasToFullPath( file_ref, src_file_path );
				error = PlayeventSave( src_file_path );
				if (error)
				{
					goto returnError;
				}
			}
		}
	}

returnError:	
	
	return error;
}
// end of NxPNG Save.cpp
